%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Finite Cylindrical Source. Steady state (FCSs): Man et al. (2010)       %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_FCSs(x,y,ro,z,H,lm,Cm,vT,t,QL,ax,ay)
%--Analytical solution----------------------------------------------------%
r = sqrt(x.^2+y.^2);    % radial distance [m]

% Temperature change  
T = QL*(1/4/pi/lm)*...
(dblquad(@(f,ze) 1/pi./sqrt(r^2+ro^2-2*r*ro*cos(f)+(z-ze).^2),0,pi,0,H)-...
 dblquad(@(f,ze) 1/pi./sqrt(r^2+ro^2-2*r*ro*cos(f)+(z-ze).^2),0,pi,-H,0));

%--Nomenclature-----------------------------------------------------------%
% x,y: x-y coordinates [m]
% ro: borehole radius [m]
% z: vertical coordinate [m]
% H: borehole length [m]
% lm: bulk thermal conductivity [W/m/K]
% Cm: volumetric heat capacity of the porous medium [J/m3/K] 
% vT: heat transport velocity [m/s]
% t: simulation time [s]
% QL : heat flow rate per unit length of borehole [W/m]
% ax: longitudinal thermal dispersivity 
% ay: transverse thermal dispersivity
% Please note that there are some variables which are not used in the 
% current subfunction. 